%% Modle dynamique robot 3 axes
clear all;
close all;
clc;
%% Gnration du modle
definition_modele_3axes;
%% Gnration du mouvement  tudier
dt=0.01;

Fs=1/dt;

q0=[pi/3 pi/3 pi/3]';
x_ini=[-0.0637303096670294;-0.143140619124451;0.0869693268953068];%position initiale
x_fin=[-0.00929506651806347;-0.00302015018951384;0.200487797216934];%position finale

q_ini=IK(x_ini,q0)*180/pi;%configuration initiale
q_fin=IK(x_fin,q0)*180/pi;%configuration finale

%Gnration de mouvement
delta_q=q_fin-q_ini;
res=gene_consignes_3axes(delta_q,specs.AX12A,Fs,[1 1]);

t=res.prof(:,1);
%position, vitesse, acclration
for i=1:3
q_traj(:,i)=integrale(t,res.prof(:,i+1),2)*pi/180+q_ini(i)*pi/180;
dq_traj(:,i)=res.prof(:,i+1)*pi/180;
ddq_traj(:,i)=derivate_2order(dt,res.prof(:,i+1)*pi/180);
end

%trac de la trajectoire (vrification des points init et fin)
%Xout=Trace_3axes_trajectoire(q_traj',[x_ini x_fin],specs);
%% DYNAMIQUE INVERSE

%initialisation des couples moteurs
Tau=zeros(numel(t),3)';
%dfinition de la gravit
g=9.81;



%calcul des couples moteurs (et des actions de liaison si ncessaire)
%par dynamique inverse
for i=1:numel(t)
Tau(:,i)=ID_robot_3axes(t,q_traj(i,:),dq_traj(i,:),ddq_traj(i,:),specs,g);
end


%% Trac de la courbe couples moteurs
figure;
plot(t,Tau);
xlabel('time (s)');% 
ylabel('Joint torques (N.m)');
legend({'Tau1','Tau2','Tau3'});
